/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.client.gui.screens.armorstand;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.armorstatues.api.client.gui.screens.armorstand.AbstractArmorStandScreen;
import fuzs.armorstatues.api.network.client.data.DataSyncHandler;
import fuzs.armorstatues.api.world.inventory.ArmorStandHolder;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandPose;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandScreenType;
import java.util.Optional;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Inventory;

public class ArmorStandPosesScreen
extends AbstractArmorStandScreen {
    private static final int POSES_PER_PAGE = 4;
    private static int firstPoseIndex;
    private final AbstractWidget[] cycleButtons = new AbstractWidget[2];
    private final AbstractWidget[] poseButtons = new AbstractWidget[4];

    public ArmorStandPosesScreen(ArmorStandHolder holder, Inventory inventory, Component component, DataSyncHandler dataSyncHandler) {
        super(holder, inventory, component, dataSyncHandler);
        this.inventoryEntityX = 5;
        this.inventoryEntityY = 40;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.cycleButtons[0] = (AbstractWidget)this.m_142416_((GuiEventListener)new ImageButton(this.leftPos + 17, this.topPos + 153, 20, 20, 156, 64, ARMOR_STAND_WIDGETS_LOCATION, button -> {
            firstPoseIndex -= 4;
            this.toggleCycleButtons();
        }));
        this.cycleButtons[1] = (AbstractWidget)this.m_142416_((GuiEventListener)new ImageButton(this.leftPos + 49, this.topPos + 153, 20, 20, 176, 64, ARMOR_STAND_WIDGETS_LOCATION, button -> {
            firstPoseIndex += 4;
            this.toggleCycleButtons();
        }));
        for (int i = 0; i < this.poseButtons.length; ++i) {
            int ii = i;
            this.poseButtons[i] = (AbstractWidget)this.m_142416_((GuiEventListener)new ImageButton(this.leftPos + 83 + i % 2 * 62, this.topPos + 9 + i / 2 * 88, 60, 82, 76, 0, 82, ARMOR_STAND_WIDGETS_LOCATION, 256, 256, button -> ArmorStandPosesScreen.getPoseAt(ii).ifPresent(this.dataSyncHandler::sendPose), (button, poseStack, mouseX, mouseY) -> ArmorStandPosesScreen.getPoseAt(ii).ifPresent(pose -> this.m_96602_(poseStack, pose.getComponent(), mouseX, mouseY)), CommonComponents.f_237098_));
        }
        this.toggleCycleButtons();
    }

    private void toggleCycleButtons() {
        this.cycleButtons[0].f_93623_ = firstPoseIndex > 0;
        this.cycleButtons[1].f_93623_ = firstPoseIndex + 4 < ArmorStandPose.values().length;
        for (int i = 0; i < this.poseButtons.length; ++i) {
            this.poseButtons[i].f_93624_ = ArmorStandPosesScreen.getPoseAt(i).isPresent();
        }
    }

    @Override
    protected void renderBg(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        super.renderBg(poseStack, partialTick, mouseX, mouseY);
        ArmorStand armorStand = this.holder.getArmorStand();
        ArmorStandPose entityPose = ArmorStandPose.fromEntity(armorStand);
        for (int i = 0; i < 4; ++i) {
            Optional<ArmorStandPose> pose = ArmorStandPosesScreen.getPoseAt(i);
            if (!pose.isPresent()) continue;
            pose.get().applyToEntity(armorStand);
            InventoryScreen.m_98850_((int)(this.leftPos + 112 + i % 2 * 62), (int)(this.topPos + 79 + i / 2 * 88), (int)30, (float)(this.leftPos + 112 + i % 2 * 62 - 10 - this.mouseX), (float)(this.topPos + 79 + i / 2 * 88 - 44 - this.mouseY), (LivingEntity)armorStand);
        }
        entityPose.applyToEntity(armorStand);
    }

    @Override
    protected boolean withCloseButton() {
        return false;
    }

    @Override
    public ArmorStandScreenType getScreenType() {
        return ArmorStandScreenType.POSES;
    }

    private static Optional<ArmorStandPose> getPoseAt(int index) {
        if ((index += firstPoseIndex) >= ArmorStandPose.values().length) {
            return Optional.empty();
        }
        return Optional.of(ArmorStandPose.values()[index]);
    }
}

